/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.fmtwidgets;

import com.quantumdata.fmteditor.fmt.CmdValue;
import com.quantumdata.fmteditor.fmt.CmdValueListener;
import com.quantumdata.fmteditor.fmt.CmdValueType;
import com.quantumdata.widgets.QDStdUI;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class FmtNumericField
extends JTextField {
    private CmdValue m_value;
    private boolean m_ranged = false;
    private boolean m_isHex = false;
    private int m_minVal;
    private int m_maxVal;
    private boolean m_dblRanged = false;
    private double m_dmax;
    private double m_dmin;
    private double m_scalar = 1.0;
    private CmdValueListener m_listener;

    public FmtNumericField(CmdValue cmdValue) {
        this(cmdValue, 1.0);
    }

    public FmtNumericField(CmdValue cmdValue, double d) {
        this.m_value = cmdValue;
        this.m_scalar = d;
        this.setCaretColor(QDStdUI.getActionForeground());
        this.setColumns(8);
        this.setHorizontalAlignment(4);
        this.setEnabled(true);
        this.displayValue();
        this.addListeners();
        this.setToolTipText("Set " + cmdValue.getCmd());
        this.setSelectionColor(QDStdUI.getSelectedColor());
    }

    public FmtNumericField(CmdValue cmdValue, int n, int n2) {
        this(cmdValue);
        this.setRange(n, n2);
    }

    public FmtNumericField(CmdValue cmdValue, double d, double d2) {
        this(cmdValue);
        this.setRangeDouble(d, d2);
    }

    public void setRange(int n, int n2) {
        this.m_dblRanged = false;
        this.m_ranged = true;
        this.m_minVal = n;
        this.m_maxVal = n2;
        if (this.m_minVal == this.m_maxVal) {
            this.setEnabled(false);
        }
        this.check();
    }

    public void setRangeDouble(double d, double d2) {
        this.m_ranged = false;
        this.m_dblRanged = true;
        this.m_dmin = d;
        this.m_dmax = d2;
        this.check();
    }

    public void setAsHex(boolean bl) {
        this.m_isHex = bl;
        this.check();
    }

    public CmdValue getValue() {
        return this.m_value;
    }

    public void setValue(CmdValue cmdValue) {
        this.m_value.removeListener(this.m_listener);
        this.m_value = cmdValue;
        this.m_value.addListener(this.m_listener);
        this.displayValue();
    }

    public void setScalar(double d) {
        this.m_scalar = d;
    }

    private void addListeners() {
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FmtNumericField.this.check();
                FmtNumericField.this.selectAll();
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                FmtNumericField.this.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                FmtNumericField.this.check();
            }
        });
        this.m_listener = new CmdValueListener(){

            public void valueChanged(CmdValue cmdValue) {
                FmtNumericField.this.displayValue();
            }
        };
        this.m_value.addListener(this.m_listener);
    }

    public void displayValue() {
        if (this.m_value.getType() == CmdValueType.DOUBLE) {
            double d = this.m_value.getDouble() / this.m_scalar;
            this.setText(String.format("%.6f", d));
        } else if (this.m_isHex) {
            this.setText(Integer.toString(this.m_value.getInt(), 16).toUpperCase());
        } else {
            this.setText(this.m_value.get());
        }
    }

    private void check() {
        try {
            boolean bl = false;
            if (this.m_value.getType() == CmdValueType.DOUBLE) {
                double d = Double.parseDouble(this.getText()) * this.m_scalar;
                if (this.m_dblRanged) {
                    if (d < this.m_dmin) {
                        d = this.m_dmin;
                        bl = true;
                    } else if (d > this.m_dmax) {
                        d = this.m_dmax;
                        bl = true;
                    }
                }
                this.m_value.setDouble(d);
            } else {
                int n = Integer.parseInt(this.getText(), this.m_isHex ? 16 : 10);
                if (this.m_ranged) {
                    if (n < this.m_minVal) {
                        n = this.m_minVal;
                        bl = true;
                    } else if (n > this.m_maxVal) {
                        n = this.m_maxVal;
                        bl = true;
                    }
                }
                this.m_value.setInt(n);
            }
            if (bl) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
                this.displayValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
            this.displayValue();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.setBackground(Color.black);
            this.setForeground(Color.white);
        } else {
            this.setBackground(Color.darkGray);
            this.setForeground(Color.lightGray);
        }
    }
}

